# Learning to Receive Help: Intervention-Aware Concept Embedding Models

This repository has been built on top of Espinosa Zarlenga's et al. [1]
public MIT-Licensed repository found [here](https://github.com/mateoespinosa/cem).

Upon publication, we will package all of our code for this project into a single
clean Pytorch-based library.This library will include an IntCEM model as an
out-of-the-box object one may easily instantiate.

[1] Espinosa Zarlenga, Mateo, et al. "Concept Embedding Models." NeurIPS 2022-36th Conference on Neural Information Processing Systems. 2022.

# Installation
Before running any of our experiments, you must install this code as a local
library by calling
```bash
$ python setup.py install
```
After running this, you should by able to import our modified `cem` package locally
using
```python
import cem
```

# Experiment Reproducibility

## Downloading the Datasets

In order to be able to properly run our experiments, you will
have to **download** the pre-processed *CUB dataset* found [here](https://worksheets.codalab.org/bundles/0xd013a7ba2e88481bbc07e787f73109f5) to a directory called
`data/CUB200/`. Similarly, if you wish to recreate our `CelebA` experiments,
you must downsload the *CelebA dataset* found
[here](https://mmlab.ie.cuhk.edu.hk/projects/CelebA.html) to a directory called `data/celeba`. You may opt to download either to
different locations, however their paths must be properly indicated in the `root_dir` parameter
of the experiment config that you are running.


## Running Experiments

To reproduce the experiments discussed in our paper, you can run the
following command
```bash
$ python experiments/run_experiments.py dot -c experiments/config/<task>.config
```
Where `<task>` can be any of `[mnist_add|mnist_add_incomp|cub|cub_incomp|celeba]`.
This will run all of our baselines while dumping all models and results into the `results/` folder.
At the end of each run of this experiment run, our script will also output a summary table containing
the mean metrics of interest over all random initialisations completed up to that point.